/**
 * Returns true if the inserter is opened.
 *
 * @param {Object} state Global application state.
 *
 * @return {boolean} Whether the inserter is opened.
 */
export function isInserterOpened(state) {
	return !!state.blockInserterPanel
}

/**
 * Get the insertion point for the inserter.
 *
 * @param {Object} state Global application state.
 *
 * @return {Object} The root client ID and index to insert at.
 */
export function __experimentalGetInsertionPoint(state) {
	const { rootClientId, insertionIndex } = state.blockInserterPanel
	return { rootClientId, insertionIndex }
}
